<?php
session_start();
?>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-KK94CHFLLe+nY2dmCWGMq91rCGa5gtU4mk92HdvYe+M/SXH301p5ILy+dN9+nJOZ" crossorigin="anonymous">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha3/dist/js/bootstrap.bundle.min.js" integrity="sha384-ENjdO4Dr2bkBIFxQpeoTz1HIcje39Wm4jDKdf19U8gI4ddQ3GYNS7NTKfAdVQSZe" crossorigin="anonymous"></script>


<script>
    function submitted(event) {
      event.preventDefault();
      document.getElementById("inputAlt").removeAttribute('required');
      document.getElementById("inputCrit").removeAttribute('required');
      document.getElementById("myForm").submit();
    }
  </script>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      font-family: 'Lato', sans-serif;
      font-family: 'Oswald', sans-serif;
    }

    .wrapper {
      position: fixed;
      top: 0;
      right: -100%;
      height: 100%;
      width: 100%;
      background: #000;
      transition: all 0.6s ease-in-out;
      text-align: center;
    }

    #active:checked~.wrapper {
      right: 0;
    }

    .menu-btn {
      position: absolute;
      z-index: 2;
      right: 20px;
      top: 20px;
      height: 50px;
      width: 50px;
      text-align: center;
      line-height: 50px;
      border-radius: 50%;
      font-size: 20px;
      cursor: pointer;
      transition: all 0.3s ease-in-out;
    }

    .menu-btn span,
    .menu-btn:before,
    .menu-btn:after {
      content: "";
      position: absolute;
      top: 20%;
      left: 30%;
      width: 40%;
      border-bottom: 2px solid #fff;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .menu-btn:before {
      transform: translateY(-8px);
    }

    .menu-btn:after {
      transform: translateY(8px);
    }


    .close {
      z-index: 1;
      width: 100%;
      height: 100%;
      pointer-events: none;
      transition: background .6s;
    }

    /* closing animation */
    #active:checked+.menu-btn span {
      transform: scaleX(0);
    }

    #active:checked+.menu-btn:before {
      transform: rotate(45deg);
      border-color: #fff;
    }

    #active:checked+.menu-btn:after {
      transform: rotate(-45deg);
      border-color: #fff;
    }

    .wrapper ul {
      position: absolute;
      top: 60%;
      left: 50%;
      height: 90%;
      transform: translate(-50%, -50%);
      list-style: none;
      text-align: center;
    }

    .wrapper ul li {
      height: 10%;
      margin: 15px 0;
      text-align: center;
    }

    .wrapper ul li a {
      text-decoration: none;
      font-size: 30px;
      font-weight: 500;
      padding: 5px 30px;
      color: #fff;
      border-radius: 50px;
      position: absolute;
      line-height: 50px;
      margin: 5px 30px;
      opacity: 0;
      transition: all 0.3s ease;
      transition: transform .6s cubic-bezier(0.215, 0.61, 0.355, 1);
    }

    .wrapper ul li a:after {
      position: absolute;
      content: "";
      background: #fff;
      width: 100%;
      height: 100%;
      left: 0;
      top: 0;
      border-radius: 50px;
      transform: scaleY(0);
      z-index: -1;
    }

    .wrapper ul li a:hover:after {
      transform: scaleY(1);
    }

    .wrapper ul li a:hover {
      color: #1a73e8;
    }

    input[type="checkbox"] {
      display: none;
    }

    .content {
      position: absolute;
      top: 50%;
      left: 50%;
      transform: translate(-50%, -50%);
      z-index: -1;
      text-align: center;
      width: 100%;
      color: #202020;
    }

    .content .title {
      font-size: 40px;
      font-weight: 600;
    }

    .content p {
      font-size: 35px;
      font-weight: 500;
    }

    #active:checked~.wrapper ul li a {
      opacity: 1;
    }

    .wrapper ul li a {
      transition: opacity 1.2s, transform 1.2s cubic-bezier(0.215, 0.61, 0.355, 1);
      transform: translateX(100px);
    }

    #active:checked~.wrapper ul li a {
      transform: none;
      transition-timing-function: ease, cubic-bezier(.1, 1.3, .3, 1);
      /* easeOutBackを緩めた感じ */
      transition-delay: .6s;
      transform: translateX(-100px);
    }

    .custom-badge {
      width: 200px;
      /* Adjust the width as needed */
      height: 50px;
      /* Adjust the height as needed */
      font-size: 50px;
    }

    .nav-item {
      font-size: 20px;
    }

    .navbar-brand {
      font-size: 17px;
    }
  </style>
  <link href="https://fonts.googleapis.com/css2?family=Oswald&display=swap" rel="stylesheet">
  <link href="https://fonts.googleapis.com/css2?family=Lato&display=swap" rel="stylesheet">
  <script src="https://kit.fontawesome.com/a076d05399.js"></script>


<div class="container">
<?php
$transposedData2 = $_SESSION['transposedData2'];
$numCols = $_SESSION['numCols'];
$max = $_SESSION['max'];
$min = $_SESSION['min'];

    $d_plus = [];
    $d_min = [];

    // Positif
    for ($i = 0; $i < count($transposedData2); $i++) {
        $summed = 0;
        for ($j = 0; $j < $numCols; $j++) {
            $summed = $summed + (($transposedData2[$i][$j] - $max[$j]) ** 2);
        }
        // Masukkan array
        $d_plus[] = sqrt($summed);
    }

    // Negatif
    for ($i = 0; $i < count($transposedData2); $i++) {
        $summed = 0;
        for ($j = 0; $j < $numCols; $j++) {
            $summed = $summed + (($transposedData2[$i][$j] - $min[$j]) ** 2);
        }
        // Masukkan array
        $d_min[] = sqrt($summed);
    }

    echo "<h2>Step 4: SOLUSI IDEAL POSITIF NEGATIF, D+ DAN D-</h2>";
    echo "<table table class='table table-bordered table-striped'>";
        echo "<tr><th>Index</th><th>d_plus</th><th>d_min</th></tr>";
        for ($i = 0; $i < count($d_plus); $i++) {
            echo "<tr>";
            echo "<td>{$i}</td>";
            echo "<td>{$d_plus[$i]}</td>";
            echo "<td>{$d_min[$i]}</td>";
            echo "</tr>";
        }
        echo "</table>";

        echo "<form action='step5.php' method='post'>";
        echo "<input type='submit' value='Next' class='btn btn-dark btn-lg'>";
        echo "</form>";

        $_SESSION['d_plus'] = $d_plus;
        $_SESSION['d_min'] = $d_min;
   
?>
</div>

